
-- Rain parameters
kPPS = 130;               -- Number of particles generated per second
kGravity = 600 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("bubble");
  SetBlendMode(kBlendNormal);
  SetNumParticles(100);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();

StopSpouting = NewTimeout(1800);
TestDone = NewTimeout(6000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitScale( "fRange", 0.2, .2 );
   InitAge("iRange", 500,1200);
   InitExtra1("fRange",0,1);
   InitPosition( "vRange", Vec3(-5,-5,0), Vec3(-5,5,0) );
   InitVelocity( "vRange", Vec3(10,-800,0), Vec3(100, -300, 0));
   CreateParticles(newParticles);
  end

  Gravity(kGravity);

   Do("move");
   DoAge("iAge");
   DoScale("fScale",
      .01, 1500,
      .1, 500);

   Do("expire", 2000)

   DoUp( "vRotate", 0, 0 );

end

